<?php
/* --------------------------------------------------------------
  bootstrap.inc.php 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

@date_default_timezone_set('Europe/Berlin');

if(!file_exists(__DIR__ . '/config.inc.php')
   || !file_exists(__DIR__ . '/classes/Psr4Autoloader.inc.php') 
   || !file_exists(__DIR__ . '/classes/HtmlTemplateLoader.inc.php')
)
{
	throw new \RuntimeException('StyleEdit 3 files are missing. Please upload all files!');
}

require __DIR__ . '/config.inc.php';
require __DIR__ . '/classes/Psr4Autoloader.inc.php';
require __DIR__ . '/classes/HtmlTemplateLoader.inc.php';

$loader = new \StyleEdit\Psr4Autoloader;
$loader->register();
$loader->addNamespace('StyleEdit', __DIR__ . '/classes');

// Continue with other initialization tasks ... 
